import React from "react";

export default function Pagination({
	activePage,
	handlePageClick,
	totalPages,
}) {
	return (
		<>
			{/* Pagination links */}
			{[...Array(totalPages)].map((_, index) => (
				<li
					key={index}
					className={activePage === index + 1 ? "active" : ""}
				>
					<a
						className='pagination-link animate-hover-btn'
						onClick={() => handlePageClick(index + 1)}
					>
						{index + 1}
					</a>
				</li>
			))}
			{/* Next page button */}
			<li>
				<a
					onClick={() =>
						handlePageClick(
							activePage < totalPages
								? activePage + 1
								: activePage
						)
					}
					className='pagination-link animate-hover-btn'
				>
					<span className='icon icon-arrow-right' />
				</a>
			</li>
		</>
	);
}
