"use client";
import { useContextElement } from "@/context/Context";
import { products1 } from "@/data/products";
import Image from "next/image";
import Link from "next/link";
import { useRef } from "react";
import { ShoppingCart } from 'lucide-react'; 

import { useState, useEffect } from 'react'; 

export default function ShopCart() {
	const { cartProducts, setCartProducts, setQuickViewItem } =
		useContextElement();

     const [cartItems, setCartItems] = useState([]);
     const [totalPrice, setTotalPrice] = useState([]); 

     useEffect(() => {
          const storedCart = localStorage.getItem("cartList");
          const cartProducts = storedCart ? JSON.parse(storedCart) : [];
      
          if (cartProducts.length >= 1) {
              const validIds = cartProducts
                  .map(item => item.id)
                  .filter(id => /^\d+$/.test(id));
      
              if (validIds.length) {
                  fetch(`/api/productsdatabyids?ids=${validIds.join(",")}`)
                      .then((res) => res.json())
                      .then((data) => {
                          setCartItems(data.wishlistProducts);
                          const totalPrice = data.wishlistProducts.reduce(
                              (sum, product) => sum + parseFloat(product.price),
                              0
                          );
                          setTotalPrice(totalPrice);
                      })
                      .catch((err) => console.error("Error fetching products:", err));
              } else {
                  setCartItems([]);
              }
          } else {
              setCartItems([]);
          }
      }, []);
      


	const setQuantity = (id, quantity) => {
		if (quantity >= 1) {
			const item = cartProducts.filter((elm) => elm.id == id)[0];
			const items = [...cartProducts];
			const itemIndex = items.indexOf(item);
			item.quantity = quantity;
			items[itemIndex] = item;
			setCartProducts(items);
		}
	};
     
	const removeItem = (id) => {
		setCartProducts((pre) => [...pre.filter((elm) => elm.id != id)]);
	};

	const addNoteRef = useRef();
	const addGiftRef = useRef();
	const addShipingRef = useRef();

	return (
		<div
			className='modal fullRight fade modal-shopping-cart'
			id='shoppingCart'
		>
			<div className='modal-dialog'>
				<div className='modal-content'>
					<div className='header'>
						<div className='title fw-5'><ShoppingCart/> Coș de cumpărături</div>
						<span
							className='icon-close icon-close-popup'
							data-bs-dismiss='modal'
						/>
					</div>
					<div className='wrap'>
						
						<div className='tf-mini-cart-wrap'>
							<div className='tf-mini-cart-main'>
								<div className='tf-mini-cart-sroll'>
									<div className='tf-mini-cart-items'>
										{cartItems.map(
											(elm, i) => (
												<div
													key={i}
													className='tf-mini-cart-item'
												>
													<div className='tf-mini-cart-image'>
														<Link
															href={`/${elm.url}`}
														>
															<Image
																alt='image'
																src={ 
																	elm.images?.split('|').filter(Boolean)[0]
																}
																width={
																	668
																}
																height={
																	932
																}
																style={{
																	objectFit:
																		"cover",
																}}
															/>
														</Link>
													</div>
													<div className='tf-mini-cart-info'>
														<Link
															className='title link'
															href={`/product-detail/${elm.id}`}
														>
															{
																elm.name
															}
														</Link>
														<div className='meta-variant'>
															Light
															gray
														</div>
														<div className='price fw-6'>
															{elm.price}
															
														</div>
														<div className='tf-mini-cart-btns'>
															<div className='wg-quantity small'>
																<span
																	className='btn-quantity minus-btn'
																	onClick={() =>
																		setQuantity(
																			elm.id,
																			cartProducts.find(product => product.id === elm.id)?.quantity || 0 -
																				1
																		)
																	}
																>
																	-
																</span>
																<input
																	type='text'
																	name='number'
																	value={
																		cartProducts.find(product => product.id === elm.id)?.quantity || 0
																	}
																	min={
																		1
																	}
																	onChange={(
																		e
																	) =>
																		setQuantity(
																			elm.id,
																			e
																				.target
																				.value /
																				1,
																		)
																	}
																/>
																<span
																	className='btn-quantity plus-btn'
																	onClick={() =>
																		setQuantity(
																			elm.id,
																			cartProducts.find(product => product.id === elm.id)?.quantity || 0 +
																				1
																		)
																	}
																>
																	+
																</span>
															</div>
															<div
																className='tf-mini-cart-remove'
																style={{
																	cursor: "pointer",
																}}
																onClick={() =>
																	removeItem(
																		elm.id
																	)
																}
															>
																Renunta
															</div>
														</div>
													</div>
												</div>
											)
										)}

										{!cartProducts.length && (
											<div className='container'>
												<div className='row align-items-center mt-5 mb-5'>
													<div className='col-12 fs-18'>
														Cosul de cumparaturi este gol.
													</div>
													<div className='col-12 mt-3'>
														<Link
															href={`/shop-default`}
															className='tf-btn btn-fill animate-hover-btn radius-3 w-100 justify-content-center'
															style={{
																width: "fit-content",
															}}
														>
															Vezi produse
														</Link>
													</div>
												</div>
											</div>
										)}
									</div>
						
								</div>
							</div>
							<div className='tf-mini-cart-bottom'>
						
								<div className='tf-mini-cart-bottom-wrap'>
									<div className='tf-cart-totals-discounts'>
										<div className='tf-cart-total'>
											Total
										</div>
										<div className='tf-totals-total-value fw-6'>
											{totalPrice}{" "}
											RON
										</div>
									</div>
									<div className='tf-cart-tax'>
									     Toate informatiile vor fii afisate pe pagina de checkout. 
									</div>
									<div className='tf-mini-cart-line' />
				
									<div className='tf-mini-cart-view-checkout'>
										<Link
											href={`/cos-de-cumparaturi`}
											className='tf-btn btn-outline radius-3 link w-100 justify-content-center'
										>
											<ShoppingCart size={20}/>{"  "}Vezi cosul
										</Link>
	
									</div>
								</div>
							</div>
							<div
								className='tf-mini-cart-tool-openable add-note'
								ref={addNoteRef}
							>
								<div
									className='overplay tf-mini-cart-tool-close'
									onClick={() =>
										addNoteRef.current.classList.remove(
											"open"
										)
									}
								/>
								<div className='tf-mini-cart-tool-content'>
									<label
										htmlFor='Cart-note'
										className='tf-mini-cart-tool-text'
									>
										<div className='icon'>
											<svg
												xmlns='http://www.w3.org/2000/svg'
												width={16}
												height={18}
												viewBox='0 0 16 18'
												fill='currentColor'
											>
												<path d='M5.12187 16.4582H2.78952C2.02045 16.4582 1.39476 15.8325 1.39476 15.0634V2.78952C1.39476 2.02045 2.02045 1.39476 2.78952 1.39476H11.3634C12.1325 1.39476 12.7582 2.02045 12.7582 2.78952V7.07841C12.7582 7.46357 13.0704 7.77579 13.4556 7.77579C13.8407 7.77579 14.1529 7.46357 14.1529 7.07841V2.78952C14.1529 1.25138 12.9016 0 11.3634 0H2.78952C1.25138 0 0 1.25138 0 2.78952V15.0634C0 16.6015 1.25138 17.8529 2.78952 17.8529H5.12187C5.50703 17.8529 5.81925 17.5407 5.81925 17.1555C5.81925 16.7704 5.50703 16.4582 5.12187 16.4582Z' />
												<path d='M15.3882 10.0971C14.5724 9.28136 13.2452 9.28132 12.43 10.0965L8.60127 13.9168C8.51997 13.9979 8.45997 14.0979 8.42658 14.2078L7.59276 16.9528C7.55646 17.0723 7.55292 17.1993 7.58249 17.3207C7.61206 17.442 7.67367 17.5531 7.76087 17.6425C7.84807 17.7319 7.95768 17.7962 8.07823 17.8288C8.19879 17.8613 8.32587 17.8609 8.44621 17.8276L11.261 17.0479C11.3769 17.0158 11.4824 16.9543 11.5675 16.8694L15.3882 13.0559C16.2039 12.2401 16.2039 10.9129 15.3882 10.0971ZM10.712 15.7527L9.29586 16.145L9.71028 14.7806L12.2937 12.2029L13.2801 13.1893L10.712 15.7527ZM14.4025 12.0692L14.2673 12.204L13.2811 11.2178L13.4157 11.0834C13.6876 10.8115 14.1301 10.8115 14.402 11.0834C14.6739 11.3553 14.6739 11.7977 14.4025 12.0692Z' />
											</svg>
										</div>
										<span>Add Order Note</span>
									</label>
									<textarea
										name='note'
										id='Cart-note'
										placeholder='How can we help you?'
										defaultValue={""}
									/>
									<div className='tf-cart-tool-btns justify-content-center'>
										<div
											className='tf-mini-cart-tool-primary text-center w-100 fw-6 tf-mini-cart-tool-close '
											onClick={() =>
												addNoteRef.current.classList.remove(
													"open"
												)
											}
										>
											Close
										</div>
									</div>
								</div>
							</div>
							<div
								className='tf-mini-cart-tool-openable add-gift'
								ref={addGiftRef}
							>
								<div
									className='overplay tf-mini-cart-tool-close'
									onClick={() =>
										addGiftRef.current.classList.remove(
											"open"
										)
									}
								/>
								<form
									onSubmit={(e) =>
										e.preventDefault()
									}
									className='tf-product-form-addgift'
								>
									<div className='tf-mini-cart-tool-content'>
										<div className='tf-mini-cart-tool-text'>
											<div className='icon'>
												<svg
													xmlns='http://www.w3.org/2000/svg'
													width={24}
													height={24}
													viewBox='0 0 24 24'
													fill='currentColor'
												>
													<path
														fillRule='evenodd'
														clipRule='evenodd'
														d='M4.65957 3.64545C4.65957 0.73868 7.89921 -0.995558 10.3176 0.617949L11.9997 1.74021L13.6818 0.617949C16.1001 -0.995558 19.3398 0.73868 19.3398 3.64545V4.32992H20.4286C21.9498 4.32992 23.1829 5.56311 23.1829 7.08416V9.10087C23.1829 9.61861 22.7632 10.0383 22.2454 10.0383H21.8528V20.2502C21.8528 20.254 21.8527 20.2577 21.8527 20.2614C21.8467 22.3272 20.1702 24 18.103 24H5.89634C3.82541 24 2.14658 22.3212 2.14658 20.2502V10.0384H1.75384C1.23611 10.0384 0.816406 9.61865 0.816406 9.10092V7.08421C0.816406 5.56304 2.04953 4.32992 3.57069 4.32992H4.65957V3.64545ZM6.53445 4.32992H11.0622V3.36863L9.27702 2.17757C8.10519 1.39573 6.53445 2.2357 6.53445 3.64545V4.32992ZM12.9371 3.36863V4.32992H17.4649V3.64545C17.4649 2.2357 15.8942 1.39573 14.7223 2.17756L12.9371 3.36863ZM3.57069 6.2048C3.08499 6.2048 2.69128 6.59851 2.69128 7.08421V8.16348H8.31067L8.3107 6.2048H3.57069ZM8.31071 10.0384V18.5741C8.31071 18.9075 8.48779 19.2158 8.77577 19.3838C9.06376 19.5518 9.4193 19.5542 9.70953 19.3901L11.9997 18.0953L14.2898 19.3901C14.58 19.5542 14.9356 19.5518 15.2236 19.3838C15.5115 19.2158 15.6886 18.9075 15.6886 18.5741V10.0383H19.9779V20.2137C19.9778 20.2169 19.9778 20.2201 19.9778 20.2233V20.2502C19.9778 21.2857 19.1384 22.1251 18.103 22.1251H5.89634C4.86088 22.1251 4.02146 21.2857 4.02146 20.2502V10.0384H8.31071ZM21.308 8.16344V7.08416C21.308 6.59854 20.9143 6.2048 20.4286 6.2048H15.6886V8.16344H21.308ZM13.8138 6.2048H10.1856V16.9672L11.5383 16.2024C11.8246 16.0405 12.1748 16.0405 12.461 16.2024L13.8138 16.9672V6.2048Z'
													/>
												</svg>
											</div>
											<div className='tf-gift-wrap-infos'>
												<p>
													Do you want a
													gift wrap?
												</p>
												Only
												<span className='price fw-6'>
													$5.00
												</span>
											</div>
										</div>
										<div className='tf-cart-tool-btns'>
											<button
												type='submit'
												className='tf-btn fw-6 w-100 justify-content-center btn-fill animate-hover-btn radius-3'
											>
												<span>
													Add a gift wrap
												</span>
											</button>
											<div
												className='tf-mini-cart-tool-primary text-center w-100 fw-6 tf-mini-cart-tool-close'
												onClick={() =>
													addGiftRef.current.classList.remove(
														"open"
													)
												}
											>
												Cancel
											</div>
										</div>
									</div>
								</form>
							</div>
							<div
								className='tf-mini-cart-tool-openable estimate-shipping'
								ref={addShipingRef}
							>
								<div
									className='overplay tf-mini-cart-tool-close'
									onClick={() =>
										addShipingRef.current.classList.remove(
											"open"
										)
									}
								/>
								<div className='tf-mini-cart-tool-content'>
									<div className='tf-mini-cart-tool-text'>
										<div className='icon'>
											<svg
												xmlns='http://www.w3.org/2000/svg'
												width={21}
												height={15}
												viewBox='0 0 21 15'
												fill='currentColor'
											>
												<path
													fillRule='evenodd'
													clipRule='evenodd'
													d='M0.441406 1.13155C0.441406 0.782753 0.724159 0.5 1.07295 0.5H12.4408C12.7896 0.5 13.0724 0.782753 13.0724 1.13155V2.91575H16.7859C18.8157 2.91575 20.5581 4.43473 20.5581 6.42296V11.8878C20.5581 12.2366 20.2753 12.5193 19.9265 12.5193H18.7542C18.4967 13.6534 17.4823 14.5 16.2703 14.5C15.0582 14.5 14.0439 13.6534 13.7864 12.5193H7.20445C6.94692 13.6534 5.93259 14.5 4.72054 14.5C3.50849 14.5 2.49417 13.6534 2.23664 12.5193H1.07295C0.724159 12.5193 0.441406 12.2366 0.441406 11.8878V1.13155ZM2.26988 11.2562C2.57292 10.1881 3.55537 9.40578 4.72054 9.40578C5.88572 9.40578 6.86817 10.1881 7.17121 11.2562H11.8093V1.76309H1.7045V11.2562H2.26988ZM13.0724 4.17884V6.68916H19.295V6.42296C19.295 5.2348 18.2252 4.17884 16.7859 4.17884H13.0724ZM19.295 7.95226H13.0724V11.2562H13.8196C14.1227 10.1881 15.1051 9.40578 16.2703 9.40578C17.4355 9.40578 18.4179 10.1881 18.7209 11.2562H19.295V7.95226ZM4.72054 10.6689C4.0114 10.6689 3.43652 11.2437 3.43652 11.9529C3.43652 12.662 4.0114 13.2369 4.72054 13.2369C5.42969 13.2369 6.00456 12.662 6.00456 11.9529C6.00456 11.2437 5.42969 10.6689 4.72054 10.6689ZM16.2703 10.6689C15.5611 10.6689 14.9863 11.2437 14.9863 11.9529C14.9863 12.662 15.5611 13.2369 16.2703 13.2369C16.9794 13.2369 17.5543 12.662 17.5543 11.9529C17.5543 11.2437 16.9794 10.6689 16.2703 10.6689Z'
												/>
											</svg>
										</div>
										<span className='fw-6'>
											Estimate Shipping
										</span>
									</div>
									<div className='field'>
										<p>Country</p>
										<select
											className='tf-select w-100'
											id='ShippingCountry_CartDrawer-Form'
											name='address[country]'
											data-default=''
										>
											<option
												value='---'
												data-provinces='[]'
											>
												---
											</option>
											<option
												value='Australia'
												data-provinces="[['Australian Capital Territory','Australian Capital Territory'],['New South Wales','New South Wales'],['Northern Territory','Northern Territory'],['Queensland','Queensland'],['South Australia','South Australia'],['Tasmania','Tasmania'],['Victoria','Victoria'],['Western Australia','Western Australia']]"
											>
												Australia
											</option>
											<option
												value='Austria'
												data-provinces='[]'
											>
												Austria
											</option>
											<option
												value='Belgium'
												data-provinces='[]'
											>
												Belgium
											</option>
											<option
												value='Canada'
												data-provinces="[['Alberta','Alberta'],['British Columbia','British Columbia'],['Manitoba','Manitoba'],['New Brunswick','New Brunswick'],['Newfoundland and Labrador','Newfoundland and Labrador'],['Northwest Territories','Northwest Territories'],['Nova Scotia','Nova Scotia'],['Nunavut','Nunavut'],['Ontario','Ontario'],['Prince Edward Island','Prince Edward Island'],['Quebec','Quebec'],['Saskatchewan','Saskatchewan'],['Yukon','Yukon']]"
											>
												Canada
											</option>
											<option
												value='Czech Republic'
												data-provinces='[]'
											>
												Czechia
											</option>
											<option
												value='Denmark'
												data-provinces='[]'
											>
												Denmark
											</option>
											<option
												value='Finland'
												data-provinces='[]'
											>
												Finland
											</option>
											<option
												value='France'
												data-provinces='[]'
											>
												France
											</option>
											<option
												value='Germany'
												data-provinces='[]'
											>
												Germany
											</option>
											<option
												value='Hong Kong'
												data-provinces="[['Hong Kong Island','Hong Kong Island'],['Kowloon','Kowloon'],['New Territories','New Territories']]"
											>
												Hong Kong SAR
											</option>
											<option
												value='Ireland'
												data-provinces="[['Carlow','Carlow'],['Cavan','Cavan'],['Clare','Clare'],['Cork','Cork'],['Donegal','Donegal'],['Dublin','Dublin'],['Galway','Galway'],['Kerry','Kerry'],['Kildare','Kildare'],['Kilkenny','Kilkenny'],['Laois','Laois'],['Leitrim','Leitrim'],['Limerick','Limerick'],['Longford','Longford'],['Louth','Louth'],['Mayo','Mayo'],['Meath','Meath'],['Monaghan','Monaghan'],['Offaly','Offaly'],['Roscommon','Roscommon'],['Sligo','Sligo'],['Tipperary','Tipperary'],['Waterford','Waterford'],['Westmeath','Westmeath'],['Wexford','Wexford'],['Wicklow','Wicklow']]"
											>
												Ireland
											</option>
											<option
												value='Israel'
												data-provinces='[]'
											>
												Israel
											</option>
											<option
												value='Italy'
												data-provinces="[['Agrigento','Agrigento'],['Alessandria','Alessandria'],['Ancona','Ancona'],['Aosta','Aosta Valley'],['Arezzo','Arezzo'],['Ascoli Piceno','Ascoli Piceno'],['Asti','Asti'],['Avellino','Avellino'],['Bari','Bari'],['Barletta-Andria-Trani','Barletta-Andria-Trani'],['Belluno','Belluno'],['Benevento','Benevento'],['Bergamo','Bergamo'],['Biella','Biella'],['Bologna','Bologna'],['Bolzano','South Tyrol'],['Brescia','Brescia'],['Brindisi','Brindisi'],['Cagliari','Cagliari'],['Caltanissetta','Caltanissetta'],['Campobasso','Campobasso'],['Carbonia-Iglesias','Carbonia-Iglesias'],['Caserta','Caserta'],['Catania','Catania'],['Catanzaro','Catanzaro'],['Chieti','Chieti'],['Como','Como'],['Cosenza','Cosenza'],['Cremona','Cremona'],['Crotone','Crotone'],['Cuneo','Cuneo'],['Enna','Enna'],['Fermo','Fermo'],['Ferrara','Ferrara'],['Firenze','Florence'],['Foggia','Foggia'],['Forlì-Cesena','Forlì-Cesena'],['Frosinone','Frosinone'],['Genova','Genoa'],['Gorizia','Gorizia'],['Grosseto','Grosseto'],['Imperia','Imperia'],['Isernia','Isernia'],['L'Aquila','L’Aquila'],['La Spezia','La Spezia'],['Latina','Latina'],['Lecce','Lecce'],['Lecco','Lecco'],['Livorno','Livorno'],['Lodi','Lodi'],['Lucca','Lucca'],['Macerata','Macerata'],['Mantova','Mantua'],['Massa-Carrara','Massa and Carrara'],['Matera','Matera'],['Medio Campidano','Medio Campidano'],['Messina','Messina'],['Milano','Milan'],['Modena','Modena'],['Monza e Brianza','Monza and Brianza'],['Napoli','Naples'],['Novara','Novara'],['Nuoro','Nuoro'],['Ogliastra','Ogliastra'],['Olbia-Tempio','Olbia-Tempio'],['Oristano','Oristano'],['Padova','Padua'],['Palermo','Palermo'],['Parma','Parma'],['Pavia','Pavia'],['Perugia','Perugia'],['Pesaro e Urbino','Pesaro and Urbino'],['Pescara','Pescara'],['Piacenza','Piacenza'],['Pisa','Pisa'],['Pistoia','Pistoia'],['Pordenone','Pordenone'],['Potenza','Potenza'],['Prato','Prato'],['Ragusa','Ragusa'],['Ravenna','Ravenna'],['Reggio Calabria','Reggio Calabria'],['Reggio Emilia','Reggio Emilia'],['Rieti','Rieti'],['Rimini','Rimini'],['Roma','Rome'],['Rovigo','Rovigo'],['Salerno','Salerno'],['Sassari','Sassari'],['Savona','Savona'],['Siena','Siena'],['Siracusa','Syracuse'],['Sondrio','Sondrio'],['Taranto','Taranto'],['Teramo','Teramo'],['Terni','Terni'],['Torino','Turin'],['Trapani','Trapani'],['Trento','Trentino'],['Treviso','Treviso'],['Trieste','Trieste'],['Udine','Udine'],['Varese','Varese'],['Venezia','Venice'],['Verbano-Cusio-Ossola','Verbano-Cusio-Ossola'],['Vercelli','Vercelli'],['Verona','Verona'],['Vibo Valentia','Vibo Valentia'],['Vicenza','Vicenza'],['Viterbo','Viterbo']]"
											>
												Italy
											</option>
											<option
												value='Japan'
												data-provinces="[['Aichi','Aichi'],['Akita','Akita'],['Aomori','Aomori'],['Chiba','Chiba'],['Ehime','Ehime'],['Fukui','Fukui'],['Fukuoka','Fukuoka'],['Fukushima','Fukushima'],['Gifu','Gifu'],['Gunma','Gunma'],['Hiroshima','Hiroshima'],['Hokkaidō','Hokkaido'],['Hyōgo','Hyogo'],['Ibaraki','Ibaraki'],['Ishikawa','Ishikawa'],['Iwate','Iwate'],['Kagawa','Kagawa'],['Kagoshima','Kagoshima'],['Kanagawa','Kanagawa'],['Kumamoto','Kumamoto'],['Kyōto','Kyoto'],['Kōchi','Kochi'],['Mie','Mie'],['Miyagi','Miyagi'],['Miyazaki','Miyazaki'],['Nagano','Nagano'],['Nagasaki','Nagasaki'],['Nara','Nara'],['Niigata','Niigata'],['Okayama','Okayama'],['Okinawa','Okinawa'],['Saga','Saga'],['Saitama','Saitama'],['Shiga','Shiga'],['Shimane','Shimane'],['Shizuoka','Shizuoka'],['Tochigi','Tochigi'],['Tokushima','Tokushima'],['Tottori','Tottori'],['Toyama','Toyama'],['Tōkyō','Tokyo'],['Wakayama','Wakayama'],['Yamagata','Yamagata'],['Yamaguchi','Yamaguchi'],['Yamanashi','Yamanashi'],['Ōita','Oita'],['Ōsaka','Osaka']]"
											>
												Japan
											</option>
											<option
												value='Malaysia'
												data-provinces="[['Johor','Johor'],['Kedah','Kedah'],['Kelantan','Kelantan'],['Kuala Lumpur','Kuala Lumpur'],['Labuan','Labuan'],['Melaka','Malacca'],['Negeri Sembilan','Negeri Sembilan'],['Pahang','Pahang'],['Penang','Penang'],['Perak','Perak'],['Perlis','Perlis'],['Putrajaya','Putrajaya'],['Sabah','Sabah'],['Sarawak','Sarawak'],['Selangor','Selangor'],['Terengganu','Terengganu']]"
											>
												Malaysia
											</option>
											<option
												value='Netherlands'
												data-provinces='[]'
											>
												Netherlands
											</option>
											<option
												value='New Zealand'
												data-provinces="[['Auckland','Auckland'],['Bay of Plenty','Bay of Plenty'],['Canterbury','Canterbury'],['Chatham Islands','Chatham Islands'],['Gisborne','Gisborne'],['Hawke's Bay','Hawke’s Bay'],['Manawatu-Wanganui','Manawatū-Whanganui'],['Marlborough','Marlborough'],['Nelson','Nelson'],['Northland','Northland'],['Otago','Otago'],['Southland','Southland'],['Taranaki','Taranaki'],['Tasman','Tasman'],['Waikato','Waikato'],['Wellington','Wellington'],['West Coast','West Coast']]"
											>
												New Zealand
											</option>
											<option
												value='Norway'
												data-provinces='[]'
											>
												Norway
											</option>
											<option
												value='Poland'
												data-provinces='[]'
											>
												Poland
											</option>
											<option
												value='Portugal'
												data-provinces="[['Aveiro','Aveiro'],['Açores','Azores'],['Beja','Beja'],['Braga','Braga'],['Bragança','Bragança'],['Castelo Branco','Castelo Branco'],['Coimbra','Coimbra'],['Faro','Faro'],['Guarda','Guarda'],['Leiria','Leiria'],['Lisboa','Lisbon'],['Madeira','Madeira'],['Portalegre','Portalegre'],['Porto','Porto'],['Santarém','Santarém'],['Setúbal','Setúbal'],['Viana do Castelo','Viana do Castelo'],['Vila Real','Vila Real'],['Viseu','Viseu'],['Évora','Évora']]"
											>
												Portugal
											</option>
											<option
												value='Singapore'
												data-provinces='[]'
											>
												Singapore
											</option>
											<option
												value='South Korea'
												data-provinces="[['Busan','Busan'],['Chungbuk','North Chungcheong'],['Chungnam','South Chungcheong'],['Daegu','Daegu'],['Daejeon','Daejeon'],['Gangwon','Gangwon'],['Gwangju','Gwangju City'],['Gyeongbuk','North Gyeongsang'],['Gyeonggi','Gyeonggi'],['Gyeongnam','South Gyeongsang'],['Incheon','Incheon'],['Jeju','Jeju'],['Jeonbuk','North Jeolla'],['Jeonnam','South Jeolla'],['Sejong','Sejong'],['Seoul','Seoul'],['Ulsan','Ulsan']]"
											>
												South Korea
											</option>
											<option
												value='Spain'
												data-provinces="[['A Coruña','A Coruña'],['Albacete','Albacete'],['Alicante','Alicante'],['Almería','Almería'],['Asturias','Asturias Province'],['Badajoz','Badajoz'],['Balears','Balears Province'],['Barcelona','Barcelona'],['Burgos','Burgos'],['Cantabria','Cantabria Province'],['Castellón','Castellón'],['Ceuta','Ceuta'],['Ciudad Real','Ciudad Real'],['Cuenca','Cuenca'],['Cáceres','Cáceres'],['Cádiz','Cádiz'],['Córdoba','Córdoba'],['Girona','Girona'],['Granada','Granada'],['Guadalajara','Guadalajara'],['Guipúzcoa','Gipuzkoa'],['Huelva','Huelva'],['Huesca','Huesca'],['Jaén','Jaén'],['La Rioja','La Rioja Province'],['Las Palmas','Las Palmas'],['León','León'],['Lleida','Lleida'],['Lugo','Lugo'],['Madrid','Madrid Province'],['Melilla','Melilla'],['Murcia','Murcia'],['Málaga','Málaga'],['Navarra','Navarra'],['Ourense','Ourense'],['Palencia','Palencia'],['Pontevedra','Pontevedra'],['Salamanca','Salamanca'],['Santa Cruz de Tenerife','Santa Cruz de Tenerife'],['Segovia','Segovia'],['Sevilla','Seville'],['Soria','Soria'],['Tarragona','Tarragona'],['Teruel','Teruel'],['Toledo','Toledo'],['Valencia','Valencia'],['Valladolid','Valladolid'],['Vizcaya','Biscay'],['Zamora','Zamora'],['Zaragoza','Zaragoza'],['Álava','Álava'],['Ávila','Ávila']]"
											>
												Spain
											</option>
											<option
												value='Sweden'
												data-provinces='[]'
											>
												Sweden
											</option>
											<option
												value='Switzerland'
												data-provinces='[]'
											>
												Switzerland
											</option>
											<option
												value='United Arab Emirates'
												data-provinces="[['Abu Dhabi','Abu Dhabi'],['Ajman','Ajman'],['Dubai','Dubai'],['Fujairah','Fujairah'],['Ras al-Khaimah','Ras al-Khaimah'],['Sharjah','Sharjah'],['Umm al-Quwain','Umm al-Quwain']]"
											>
												United Arab Emirates
											</option>
											<option
												value='United Kingdom'
												data-provinces="[['British Forces','British Forces'],['England','England'],['Northern Ireland','Northern Ireland'],['Scotland','Scotland'],['Wales','Wales']]"
											>
												United Kingdom
											</option>
											<option
												value='United States'
												data-provinces="[['Alabama','Alabama'],['Alaska','Alaska'],['American Samoa','American Samoa'],['Arizona','Arizona'],['Arkansas','Arkansas'],['Armed Forces Americas','Armed Forces Americas'],['Armed Forces Europe','Armed Forces Europe'],['Armed Forces Pacific','Armed Forces Pacific'],['California','California'],['Colorado','Colorado'],['Connecticut','Connecticut'],['Delaware','Delaware'],['District of Columbia','Washington DC'],['Federated States of Micronesia','Micronesia'],['Florida','Florida'],['Georgia','Georgia'],['Guam','Guam'],['Hawaii','Hawaii'],['Idaho','Idaho'],['Illinois','Illinois'],['Indiana','Indiana'],['Iowa','Iowa'],['Kansas','Kansas'],['Kentucky','Kentucky'],['Louisiana','Louisiana'],['Maine','Maine'],['Marshall Islands','Marshall Islands'],['Maryland','Maryland'],['Massachusetts','Massachusetts'],['Michigan','Michigan'],['Minnesota','Minnesota'],['Mississippi','Mississippi'],['Missouri','Missouri'],['Montana','Montana'],['Nebraska','Nebraska'],['Nevada','Nevada'],['New Hampshire','New Hampshire'],['New Jersey','New Jersey'],['New Mexico','New Mexico'],['New York','New York'],['North Carolina','North Carolina'],['North Dakota','North Dakota'],['Northern Mariana Islands','Northern Mariana Islands'],['Ohio','Ohio'],['Oklahoma','Oklahoma'],['Oregon','Oregon'],['Palau','Palau'],['Pennsylvania','Pennsylvania'],['Puerto Rico','Puerto Rico'],['Rhode Island','Rhode Island'],['South Carolina','South Carolina'],['South Dakota','South Dakota'],['Tennessee','Tennessee'],['Texas','Texas'],['Utah','Utah'],['Vermont','Vermont'],['Virgin Islands','U.S. Virgin Islands'],['Virginia','Virginia'],['Washington','Washington'],['West Virginia','West Virginia'],['Wisconsin','Wisconsin'],['Wyoming','Wyoming']]"
											>
												United States
											</option>
											<option
												value='Vietnam'
												data-provinces='[]'
											>
												Vietnam
											</option>
										</select>
									</div>
									<div className='field'>
										<p>Zip code</p>
										<input
											type='text'
											name='text'
											placeholder=''
										/>
									</div>
									<div className='tf-cart-tool-btns'>
										<a
											href='#'
											className='tf-btn fw-6 justify-content-center btn-fill w-100 animate-hover-btn radius-3'
										>
											<span>Estimate</span>
										</a>
										<div
											className='tf-mini-cart-tool-primary text-center fw-6 w-100 tf-mini-cart-tool-close'
											onClick={() =>
												addShipingRef.current.classList.remove(
													"open"
												)
											}
										>
											Cancel
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	);
}
