import { apiHandler, db } from '@/helpers/api';

export default apiHandler({
     get: getUserData
});

async function getUserData(req, res) {
     const userID = req.userID;

     if(!db.initialized)
          await db.initialize(); 

     try {
          const userData = await db.User.findByPk(userID); 
          
          if (!userData) 
               return res.status(404).json({ error: 'Unknown!' });

          const responseArray = [];
          //const articleCount = await db.Cart.count({forID:userData.id}); 
          responseArray.push({ userData/*,articleCount */});

          return res.status(200).json(responseArray);
     } catch (error) {
          return res.status(500).json({ error: 'Eroare la preluarea datelor utilizatorului.' });
     }
}