import { apiHandler, db } from '@/helpers/api';

export default apiHandler({
     post: editBackground
});

async function editBackground(req, res) {
     const userID = req.userID;
     const data = req.body; 

     if(!db.initialized)
          await db.initialize(); 

     try {
          const userData = await db.User.findByPk(userID); 
          
          if (!userData) 
               return res.status(404).json({ error: 'Unknown!' });

          await db.User.update(
               { background: data.documentLocation }, 
               { where: { id:userID } }
          );

          return res.status(200).json({ message: 'Felicitari! Background-ul a fost actualizat cu succes.' });
     } catch (error) {
          return res.status(500).json({ error: 'Unexpected Error!' });
     }
}