import React from "react";
import Image from "next/image";
import Link from "next/link";
import { featuredProducts } from "@/data/products";
import { galleryItems } from "@/data/gallery";
import { categories } from "@/data/categories";
import { socialLinks } from "@/data/socials";
export default function Sidebar() {
	return (
		<aside className="tf-shop-sidebar wrap-sidebar-mobile">
			<div className="widget-facet wd-categories">
				<div
					className="facet-title"
					data-bs-target="#categories"
					data-bs-toggle="collapse"
					aria-expanded="true"
					aria-controls="categories"
				>
					<span>Filtre</span>
					<span className="icon icon-arrow-up" />
				</div>
				<div id="categories" className="collapse show">
					<ul className="list-categoris current-scrollbar mb_36">
						{categories.map((category, index) => (
							<li
								key={index}
								className={`cate-item ${category.className}`}
							>
								<a href="#">
									<span>{category.name}</span>&nbsp;
									<span>({category.count})</span>
								</a>
							</li>
						))}
					</ul>
				</div>
			</div>

		</aside>
	);
}
