"use client";
import { products1 } from "@/data/products";
import { sortingOptions } from "@/data/shop";
import React, { useEffect, useState } from "react";

export default function Sorting({ products, setFinalSorted }) {
	const [selectedOptions, setSelectedOptions] = useState(sortingOptions[0]);

	useEffect(() => {
          console.log(products); 
		if (selectedOptions.text == "Default") {
			setFinalSorted([...products]);
		} else if (selectedOptions.text == "Alfabetic, A-Z") {
			setFinalSorted(
				[...products].sort((a, b) => a.name.localeCompare(b.name))
			);
		} else if (selectedOptions.text == "Alfabetic, Z-A") {
			setFinalSorted(
				[...products].sort((a, b) => b.name.localeCompare(a.name))
			);
		} else if (selectedOptions.text == "Pret, de la mic la mare") {
			setFinalSorted([...products].sort((a, b) => a.price - b.price));
		} else if (selectedOptions.text == "Pret, de la mare la mic") {
			setFinalSorted([...products].sort((a, b) => b.price - a.price));
		}
	}, [products, selectedOptions]);

	return (
		<>
			{" "}
			<div className='btn-select'>
				<span className='text-sort-value'>
					{selectedOptions.text}
				</span>
				<span className='icon icon-arrow-down' />
			</div>
			<div className='dropdown-menu'>
				{sortingOptions.map((item, index) => (
					<div
						key={index}
						onClick={() => setSelectedOptions(item)}
						className={`select-item ${
							item == selectedOptions ? "active" : ""
						}`}
					>
						<span className='text-value-item'>
							{item.text}
						</span>
					</div>
				))}
			</div>
		</>
	);
}
