"use client";
import Image from "next/image";
import Link from "next/link";
import { Heart } from "lucide-react";
import { useState } from "react";
import { useContextElement } from "@/context/Context";

export const ProductCard = ({ product }) => {

     const [isFavorite, setIsFavorite] = useState(false);

     const toggleFavorite = (e) => {
          e.preventDefault();
          setIsFavorite(!isFavorite);
     };

     const {
          addToWishlist,
          isAddedtoWishlist,
          
     } = useContextElement();

	return (
		<div className='card-product fl-item' key={product.id} style={{ 
               position: "relative", 
               boxShadow: "0px 4px 10px rgba(0, 0, 0, 0.1)", 
               borderRadius: "10px", 
               padding: "10px",
               transition: "transform 0.2s ease-in-out"
           }}>
			<div className='card-product-wrapper' style={{ position: "relative" }}>
				<Link
					href={`/${product.url}`}
					className='product-img' style={{ justifyContent:'center' }}
               
				>
					<Image
						className='lazyload'
						data-src={product.images?.split('|').filter(Boolean)[0]}
						src={product.images?.split('|').filter(Boolean)[0]}
						alt='image-product'
						width={420}
						height={230}
                              style={{
                                   width: '100%',
                                   height: '230px',
                                   objectFit: 'contain',
                                   objectPosition: 'center',
                                   backgroundColor: '#fff'
                               }}
                               
                               
					/>
					
				</Link>
				
				<button
                         onClick={() => addToWishlist(product.id)}
                         style={{
                              position: "absolute",
                              top: "10px",
                              right: "10px",
                              padding: "8px",
                              borderRadius: "50%",
                              backgroundColor: isAddedtoWishlist(product.id) ? "#e53e3e" : "#ffffff",
                              color: isAddedtoWishlist(product.id) ? "#ffffff" : "#6b7280",
                              border: "none",
                              boxShadow: "0 2px 5px rgba(0,0,0,0.2)",
                              cursor: "pointer",
                              transition: "background-color 0.2s, color 0.2s"
                         }}
                         onMouseEnter={(e) => {
                              e.currentTarget.style.backgroundColor = "#e53e3e";
                              e.currentTarget.style.color = "#ffffff";
                         }}
                         onMouseLeave={(e) => {
                              e.currentTarget.style.backgroundColor = isAddedtoWishlist(product.id) ? "#e53e3e" : "#ffffff";
                              e.currentTarget.style.color = isAddedtoWishlist(product.id) ? "#ffffff" : "#6b7280";
                         }}
                    >
                         <Heart fill={isAddedtoWishlist(product.id) ? "currentColor" : "none"} size={24} />
                    </button>
			</div>
			<div className='card-product-info'>
				<Link
					href={`/${product.url}`}
					className='title link'
				>
					{product.name}
				</Link>
				
                    <div className="col-lg-12">
                         <div className="row align-items-center">
                              <div className="col-8">
                                   {product.priceReduced && product.priceReduced.length > 0 && (
                                        <span 
                                             className="text-muted text-decoration-line-through" 
                                             style={{ fontSize: '14px', color: '#777' }}
                                        >
                                             {product.priceReduced} RON
                                        </span> 
                                   )}

                                   <br/>
                                   
                                   <span style={{ color: 'red', fontWeight: 'bold', fontSize: '18px' }}>
                                        {product.price} <span style={{ fontSize: '14px' }}> RON</span>
                                   </span>
                                  
                              </div>
                              <div className="col-4 d-flex justify-content-center">
                                   <button 
                                        className="btn btn-primary btn-sm rounded-circle d-flex align-items-center justify-content-center" 
                                        style={{ width: '40px', height: '40px' }}
                                   >
                                        <i className="icon icon-bag" style={{ fontSize: '18px' }} />
                                   </button>
                              </div>
                         </div>
                    </div>
                    
			</div>
		</div>
	);
};
