"use client";
import { allProducts } from "@/data/products";
import { openCartModal } from "@/utlis/openCartModal";
// import { openCart } from "@/utlis/toggleCart";
import React, { useEffect } from "react";
import { useContext, useState } from "react";
const dataContext = React.createContext();

// Toast Notification
import { toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

export const useContextElement = () => {
	return useContext(dataContext);
};

export default function Context({ children }) {
	const [cartProducts, setCartProducts] = useState([]);
	const [wishList, setWishList] = useState([1, 2, 3]);
	const [compareItem, setCompareItem] = useState([1, 2, 3]);
	const [quickViewItem, setQuickViewItem] = useState(allProducts[0]);
	const [quickAddItem, setQuickAddItem] = useState(1);
	const [totalPrice, setTotalPrice] = useState(0);
	
     useEffect(() => {
		const subtotal = cartProducts.reduce((accumulator, product) => {
			return accumulator + product.quantity * product.price;
		}, 0);
		setTotalPrice(subtotal);
	}, [cartProducts]);

	
	const isAddedToCartProducts = (id) => {
		if (cartProducts.filter((elm) => elm.id == id)[0]) {
			return true;
		}
		return false;
	};

	const addToWishlist = (id) => {
		if (!wishList.includes(id)) {
			setWishList((pre) => [...pre, id]);
               toast.success('Produsul a fost adăugat la favorite.'); 
		} else {
			setWishList((pre) => [...pre].filter((elm) => elm != id));
               toast.info('Produsul a fost eliminat de la Favorite.'); 
		}
	};

     const addProductToCart = (id, qty) => {
		if (!cartProducts.filter((elm) => elm.id == id)[0]) {
			const item = {
				id,
				quantity: qty ? qty : 1,
			};
			setCartProducts((pre) => [...pre, item]);
			openCartModal();

			// openCart();
		}
	};

	const removeFromWishlist = (id) => {
		if (wishList.includes(id)) {
			setWishList((pre) => [...pre.filter((elm) => elm != id)]);
		}
	};
	const addToCompareItem = (id) => {
		if (!compareItem.includes(id)) {
			setCompareItem((pre) => [...pre, id]);
		}
	};
	const removeFromCompareItem = (id) => {
		if (compareItem.includes(id)) {
			setCompareItem((pre) => [...pre.filter((elm) => elm != id)]);
		}
	};
	const isAddedtoWishlist = (id) => {
		if (wishList.includes(id)) {
			return true;
		}
		return false;
	};
	const isAddedtoCompareItem = (id) => {
		if (compareItem.includes(id)) {
			return true;
		}
		return false;
	};
	useEffect(() => {
		const items = JSON.parse(localStorage.getItem("cartList"));
		if (items?.length) {
			setCartProducts(items);
		}
	}, []);

	useEffect(() => {
		localStorage.setItem("cartList", JSON.stringify(cartProducts));
	}, [cartProducts]);

	useEffect(() => {
		const items = JSON.parse(localStorage.getItem("wishlist"));
		if (items?.length) {
			setWishList(items);
		}
	}, []);

	useEffect(() => {
		localStorage.setItem("wishlist", JSON.stringify(wishList));
	}, [wishList]);

	const contextElement = {
		cartProducts,
		setCartProducts,
		totalPrice,
		addProductToCart,
		isAddedToCartProducts,
		removeFromWishlist,
		addToWishlist,
		isAddedtoWishlist,
		quickViewItem,
		wishList,
		setQuickViewItem,
		quickAddItem,
		setQuickAddItem,
		addToCompareItem,
		isAddedtoCompareItem,
		removeFromCompareItem,
		compareItem,
		setCompareItem,
	};
	return (
		<dataContext.Provider value={contextElement}>
			{children}
		</dataContext.Provider>
	);
}
