import { apiHandler, db } from '@/helpers/api';

export default apiHandler({
     post: updateProfileSocials
});

async function updateProfileSocials(req, res) {
     const userID = req.userID;
     const formData = req.body; 

     if(!db.initialized)
          await db.initialize(); 

     try {
          const userData = await db.User.findByPk(userID); 
          
          if (!userData) 
               return res.status(404).json({ error: 'Unknown!' });

          await db.User.update(
               {
                    facebook: formData.facebook,
                    twitter: formData.twitter, 
                    linkedin: formData.linkedin,
                    github: formData.github 
               },
               {
                    where: {
                         id: userData.id
                    },
                    limit: 1
               }
          );
          

          res.status(200).json({ message: "Setarile link-urilor sociale au fost actualizate!", status: 200});
     } catch (error) {
         
          return res.status(500).json({ error: error });
     }
}